<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Upload extends Model 
{

    protected $table = 'uploads';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'name', 'path', 'extension');

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

}